import textwrap
from collections import defaultdict
from datetime import date
from pathlib import Path
from qgis.core import QgsMessageLog
from qgis.PyQt.QtWidgets import QMessageBox
from qgis.utils import iface

FOLDER_Z_DANYMI = Path("/home/tomasz/Pulpit/akcje/")

layer = iface.activeLayer()
features = layer.getSelectedFeatures()

#? pobieram teryty z zaznaczonych obiektów do listy
teryty = [feat['teryt'] for feat in features if feat['teryt'] is not None]
# teryty = ["281411_2.0013.14/10", "281411_2.0012.119/19", "281411_2.0012.119/31", '281401_4.0002.100/2', '281401_4.0002.100/3'] #? przykładowe teryty do testów

#? generuję datę pisma w formacie dd.mm.rrrr
data_pisma = date.today().strftime("%d.%m.%Y")

#? słowniki z danymi o obrębach, gminach i powiatach oraz adresami JST - normalnie byłyby odczytane z bazy danych lub pliku konfiguracyjnego
slownik_obrebow = {
    "281401_4.0001": "Miasto Barczewo 1",
    "281401_4.0002": "Miasto Barczewo 2",
    "281401_4.0003": "Miasto Barczewo 3",
    "281401_5.0001": "Barczewko",
    "281401_5.0002": "Bartołty Wielkie",
    "281401_5.0003": "Bark Wrócikowo",
    "281401_5.0004": "Bogdany",
    "281401_5.0005": "Jedzbark",
    "281401_5.0006": "Kaplityny",
    "281401_5.0007": "Kierzliny",
    "281401_5.0008": "Klucznik",
    "281401_5.0009": "Kromerowo",
    "281401_5.0010": "Kronowo",
    "281401_5.0011": "Krupoliny",
    "281401_5.0012": "Lamkowo",
    "281401_5.0013": "Lamkówko",
    "281401_5.0014": "Leszno",
    "281401_5.0015": "Łapka",
    "281401_5.0016": "Łęgajny",
    "281401_5.0017": "Maruny",
    "281401_5.0018": "Mokiny",
    "281401_5.0019": "Nikielkowo",
    "281401_5.0020": "Próle Kołaki",
    "281401_5.0021": "Radosty",
    "281401_5.0022": "Ramsowo",
    "281401_5.0023": "Rejczuchy Zalesie",
    "281401_5.0024": "Ruszajny",
    "281401_5.0025": "Skajboty",
    "281401_5.0026": "Stare Włóki",
    "281401_5.0027": "Szynowo",
    "281401_5.0028": "Tumiany",
    "281401_5.0029": "Wipsowo",
    "281401_5.0030": "Wójtowo",
    "281402_4.0001": "Miasto Biskupiec 1",
    "281402_4.0002": "Miasto Biskupiec 2",
    "281402_4.0003": "Miasto Biskupiec 3",
    "281402_4.0004": "Miasto Biskupiec 4",
    "281402_4.0005": "Miasto Biskupiec 5",
    "281402_5.0001": "Biskupiec Kol.",
    "281402_5.0002": "Bredynki",
    "281402_5.0003": "Botowo",
    "281402_5.0004": "Biesowo",
    "281402_5.0005": "Biesówko",
    "281402_5.0006": "Borki Wielkie",
    "281402_5.0007": "Czerwonka",
    "281402_5.0008": "Kamionka",
    "281402_5.0009": "Kobułty",
    "281402_5.0010": "Labuszewo",
    "281402_5.0011": "Łabuchy",
    "281402_5.0012": "Mojtyny",
    "281402_5.0013": "Najdymowo",
    "281402_5.0014": "Nowe Marcinkowo",
    "281402_5.0015": "Parleza Mała",
    "281402_5.0016": "Rasząg",
    "281402_5.0017": "Rukławki",
    "281402_5.0018": "Rudziska",
    "281402_5.0019": "Rzeck",
    "281402_5.0020": "Sadowo",
    "281402_5.0021": "Stanclewo",
    "281402_5.0022": "Stryjewo",
    "281402_5.0023": "Węgój",
    "281402_5.0024": "Wilimy",
    "281402_5.0025": "Zabrodzie Dworzec",
    "281402_5.0026": "Zarębiec",
    "281402_5.0027": "Adamowo",
    "281402_5.0028": "Lipowo",
    "281402_5.0029": "Pudląg",
    "281403_4.0001": "Miasto Dobre Miasto 1",
    "281403_4.0002": "Miasto Dobre Miasto 2",
    "281403_4.0003": "Miasto Dobre Miasto 3",
    "281403_4.0004": "Miasto Dobre Miasto 4",
    "281403_4.0005": "Miasto Dobre Miasto 5",
    "281403_5.0001": "Mawry",
    "281403_5.0002": "Piotraszewo",
    "281403_5.0003": "Bzowiec",
    "281403_5.0004": "Praslity",
    "281403_5.0005": "Smolajny",
    "281403_5.0006": "Nadleśnictwo Wichrowo",
    "281403_5.0007": "Łęgno",
    "281403_5.0008": "Nowa Wieś Mała",
    "281403_5.0009": "Kosyń",
    "281403_5.0010": "Głotowo",
    "281403_5.0011": "Knopin",
    "281403_5.0012": "Stary Dwór",
    "281403_5.0013": "Międzylesie",
    "281403_5.0014": "Orzechowo",
    "281403_5.0015": "Swobodna",
    "281403_5.0016": "Barcikowo",
    "281403_5.0017": "Podleśna",
    "281403_5.0018": "Jesionowo",
    "281403_5.0019": "Cerkiewnik",
    "281403_5.0020": "Kabikiejmy Dolne",
    "281403_5.0021": "Kabikiejmy",
    "281404_2.0001": "Brąswałd",
    "281404_2.0002": "Bukwałd",
    "281404_2.0003": "Dąbrówka Wielka",
    "281404_2.0005": "Dywity",
    "281404_2.0006": "Frączki",
    "281404_2.0007": "Gady",
    "281404_2.0008": "Gradki",
    "281404_2.0009": "Kieźliny",
    "281404_2.0010": "Ługwałd",
    "281404_2.0011": "Myki",
    "281404_2.0012": "Nowe Włóki",
    "281404_2.0013": "Plutki",
    "281404_2.0014": "Redykajny",
    "281404_2.0015": "Rozgity",
    "281404_2.0016": "Różnowo",
    "281404_2.0017": "Sętal",
    "281404_2.0018": "Spręcowo",
    "281404_2.0019": "Tuławki",
    "281404_2.0021": "Zalbki",
    "281405_2.0001": "Biesal",
    "281405_2.0002": "Dłużki",
    "281405_2.0003": "Gietrzwałd",
    "281405_2.0004": "Gronity",
    "281405_2.0005": "Guzowy Piec",
    "281405_2.0006": "Jadaminy",
    "281405_2.0007": "Łęguty",
    "281405_2.0008": "Łupstych",
    "281405_2.0009": "Naglady",
    "281405_2.0010": "Naterki",
    "281405_2.0011": "Parwółki",
    "281405_2.0012": "Pęglity",
    "281405_2.0013": "Podlejki",
    "281405_2.0014": "Rapaty",
    "281405_2.0016": "Salminek",
    "281405_2.0017": "Sząbruk",
    "281405_2.0018": "Śródka",
    "281405_2.0019": "Tomaryny",
    "281405_2.0020": "Unieszewo",
    "281405_2.0021": "Woryty",
    "281406_4.0001": "Miasto Jeziorany 1",
    "281406_5.0001": "Derc",
    "281406_5.0002": "Franknowo",
    "281406_5.0003": "Jeziorany-Kolonie",
    "281406_5.0004": "Kiersztanowo",
    "281406_5.0005": "Krokowo",
    "281406_5.0006": "Kostrzewy",
    "281406_5.0007": "Kramarzewo",
    "281406_5.0008": "Kikity",
    "281406_5.0009": "Lekity",
    "281406_5.0010": "Modliny",
    "281406_5.0011": "Miejska Wieś",
    "281406_5.0012": "Olszewnik",
    "281406_5.0013": "Polkajmy",
    "281406_5.0014": "Pierwągi",
    "281406_5.0015": "Piszewo",
    "281406_5.0016": "Radostowo",
    "281406_5.0017": "Studnica",
    "281406_5.0018": "Studzianka",
    "281406_5.0019": "Tłokowo",
    "281406_5.0020": "Zerbuń",
    "281406_5.0021": "Żardeniki",
    "281406_5.0022": "Wilkiejmy",
    "281406_5.0023": "Potryty",
    "281406_5.0024": "Wólka Szlachecka",
    "281407_2.0001": "Gamerki Wielkie",
    "281407_2.0002": "Garzewko",
    "281407_2.0003": "Giedajty",
    "281407_2.0004": "Godki",
    "281407_2.0005": "Gutkowo",
    "281407_2.0006": "Jonkowo",
    "281407_2.0007": "Kajny",
    "281407_2.0009": "Łomy",
    "281407_2.0010": "Mątki",
    "281407_2.0011": "Nowe Kawkowo",
    "281407_2.0012": "Polejki",
    "281407_2.0013": "Porbady",
    "281407_2.0014": "Pupki",
    "281407_2.0015": "Stare Kawkowo",
    "281407_2.0016": "Stękiny",
    "281407_2.0017": "Szałstry",
    "281407_2.0018": "Warkały",
    "281407_2.0019": "Węgajty",
    "281407_2.0020": "Wilimowo",
    "281407_2.0021": "Wołowno",
    "281407_2.0022": "Wrzesina",
    "281408_2.0001": "Kabiny",
    "281408_2.0002": "Kolno",
    "281408_2.0003": "Kominki",
    "281408_2.0004": "Kruzy",
    "281408_2.0005": "Lutry",
    "281408_2.0006": "Ryn Reszelski",
    "281408_2.0007": "Samławki",
    "281408_2.0008": "Tarniny",
    "281408_2.0009": "Wągsty",
    "281408_2.0010": "Wójtowo",
    "281408_2.0011": "Wysoka Dąbrowa",
    "281408_2.0012": "Bęsia",
    "281408_2.0013": "Górkowo",
    "281409_4.0001": "Miasto Olsztynek 1",
    "281409_4.0002": "Miasto Olsztynek 2",
    "281409_4.0003": "Miasto Olsztynek 3",
    "281409_4.0004": "Miasto Olsztynek 4",
    "281409_4.0005": "Miasto Olsztynek 5",
    "281409_4.0006": "Miasto Olsztynek 6",
    "281409_5.0001": "Ameryka",
    "281409_5.0002": "Czerwona Woda",
    "281409_5.0003": "Dąb",
    "281409_5.0004": "Drwęck",
    "281409_5.0005": "Elgnówko",
    "281409_5.0006": "Gaj",
    "281409_5.0007": "Gębiny",
    "281409_5.0008": "Gąsiorowo",
    "281409_5.0009": "Jemiołowo",
    "281409_5.0010": "Królikowo",
    "281409_5.0011": "Kunki",
    "281409_5.0012": "Kurki",
    "281409_5.0013": "Lichtajny",
    "281409_5.0014": "Lipowo Kurkowskie",
    "281409_5.0015": "Lutek",
    "281409_5.0016": "Łęciny",
    "281409_5.0017": "Łutynowo",
    "281409_5.0018": "Mańki",
    "281409_5.0019": "Makruty",
    "281409_5.0020": "Maróz",
    "281409_5.0021": "Mierki",
    "281409_5.0022": "Mycyny",
    "281409_5.0023": "Nadrowo",
    "281409_5.0024": "Nowa Wieś Ostródzka",
    "281409_5.0025": "Pawłowo",
    "281409_5.0026": "Platyny",
    "281409_5.0027": "Samagowo-Kąpity",
    "281409_5.0028": "Sitno",
    "281409_5.0029": "Sudwa",
    "281409_5.0030": "Świerkocin",
    "281409_5.0031": "Świętajny",
    "281409_5.0032": "Swaderki",
    "281409_5.0033": "Tomaszyn",
    "281409_5.0034": "Tolejny",
    "281409_5.0035": "Waplewo",
    "281409_5.0036": "Warlity Małe",
    "281409_5.0037": "Witramowo",
    "281409_5.0038": "Witułty",
    "281409_5.0039": "Wigwałd",
    "281409_5.0040": "Wilkowo",
    "281409_5.0041": "Zawady",
    "281409_5.0042": "Ząbie",
    "281409_5.0043": "Zezuty",
    "281410_2.0001": "Bałdy",
    "281410_2.0002": "Butryny",
    "281410_2.0003": "Gąsiorowo",
    "281410_2.0004": "Giławy",
    "281410_2.0005": "GRABOWO",
    "281410_2.0006": "Groszkowo",
    "281410_2.0007": "Kaborno",
    "281410_2.0008": "Klebark Mały",
    "281410_2.0009": "Klebark Wielki",
    "281410_2.0010": "Klewki",
    "281410_2.0011": "Linowo",
    "281410_2.0012": "Łajs",
    "281410_2.0013": "Marcinkowo",
    "281410_2.0014": "Nerwik",
    "281410_2.0015": "Nowa Kaletka",
    "281410_2.0016": "Nowa Wieś",
    "281410_2.0017": "Ostrzeszewo",
    "281410_2.0018": "Pajtuny",
    "281410_2.0019": "Patryki",
    "281410_2.0020": "Pokrzywy",
    "281410_2.0021": "Prejłowo",
    "281410_2.0022": "Przykop",
    "281410_2.0023": "Purda",
    "281410_2.0024": "Purdka",
    "281410_2.0025": "Silice",
    "281410_2.0026": "Stara Kaletka",
    "281410_2.0027": "Szczęsne",
    "281410_2.0028": "Trękus",
    "281410_2.0029": "Trękusek",
    "281410_2.0030": "Wygoda",
    "281410_2.0031": "Wyrandy",
    "281410_2.0032": "Zaborowo",
    "281410_2.0033": "Zgniłocha",
    "281411_2.0001": "Bartąg",
    "281411_2.0002": "Dorotowo",
    "281411_2.0003": "Gryźliny",
    "281411_2.0004": "Gągławki",
    "281411_2.0005": "Jaroty",
    "281411_2.0006": "Kręsk",
    "281411_2.0007": "Majdy",
    "281411_2.0008": "Miodówko",
    "281411_2.0009": "Pluski",
    "281411_2.0010": "Ruś",
    "281411_2.0011": "Rybaki",
    "281411_2.0012": "Stawiguda",
    "281411_2.0013": "Tomaszkowo",
    "281411_2.0014": "Wymój",
    "281411_2.0015": "Zezuj",
    "281412_2.0001": "Brzydowo",
    "281412_2.0002": "Garzewo",
    "281412_2.0003": "Gołogóra",
    "281412_2.0004": "Jankowo",
    "281412_2.0005": "Kalisty",
    "281412_2.0006": "Klony",
    "281412_2.0007": "Konradowo",
    "281412_2.0008": "Kwiecewo",
    "281412_2.0009": "Różynka",
    "281412_2.0010": "Skolity",
    "281412_2.0011": "Świątki",
    "281412_2.0012": "Włodowo",
    "281412_2.0013": "Worławki",
    "281412_2.0014": "Wysokie",
}
slownik_gmin = {
    "281401": "Barczewo",
    "281402": "Biskupiec",
    "281403": "Dobre Miasto",
    "281404": "Dywity",
    "281405": "Gietrzwałd",
    "281406": "Jeziorany",
    "281407": "Jonkowo",
    "281408": "Kolno",
    "281409": "Olsztynek",
    "281410": "Purda",
    "281411": "Stawiguda",
    "281412": "Świątki",
}
slownik_powiatow = {"2814": "olsztyński"}
adresy = {
    "281400": ("Starostwo Powiatowe w Olsztynie", "Plac Bema 5", "10-516", "Olsztyn"),
    "281401": ("Urząd Miejski Barczewo", "pl. Ratuszowy 1", "11-010", "Barczewo"),
    "281402": ("Urząd Miejski w Biskupcu","al. Niepodległości 2","11-300","Biskupiec"),
    "281403": ("Urząd Miejski w Dobrym Mieście","ul. Warszawska 14","11-040","Dobre Miasto"),
    "281404": ("Urząd Gminy Dywity", "ul. Olsztyńska 32", "11-001", "Dywity"),
    "281405": ("Urząd Gminy Gietrzwałd", "ul. Olsztyńska 2", "11-036", "Gietrzwałd"),
    "281406": ("Urząd Miejski w Jezioranach", "Plac Zamkowy 4", "11-320", "Jeziorany"),
    "281407": ("Urząd Gminy Jonkowo", "ul. Klonowa 2", "11-042", "Jonkowo"),
    "281408": ("Urząd Gminy Kolno", "Kolno 33", "11-311", "Kolno"),
    "281409": ("Urząd Miejski w Olsztynku", "Ratusz 1", "11-015", "Olsztynek"),
    "281410": ("Urząd Gminy Purda", "Purda 19", "11-030", "Purda"),
    "281411": ("Urząd Gminy Stawiguda", "ul. Olsztyńska 10", "11-034", "Stawiguda"),
    "281412": ("Urząd Gminy Świątki", "Świątki 87", "11-008", "Świątki"),
}

#? funkcja do podziału linii dłuższych niż 80 znaków, z zachowaniem tabulacji i bez dzielenia słów
def wrap_line(line, width=80):
    if line.lstrip() != line:  # zachowaj wiodące tabulacje/spacje
        indent = line[:len(line) - len(line.lstrip())]
    else:
        indent = ''
    return '\n'.join(textwrap.wrap(line, width=width, break_long_words=False, break_on_hyphens=False, initial_indent=indent, subsequent_indent=indent)) or line

#! grupowanie działek gminami i obrębami
dzialki_gminami = defaultdict(lambda: defaultdict(list))
for teryt in teryty:
    kod_gminy = teryt[:6]  # pierwsze 8 znaków - gmina
    kod_obrebu = teryt[:13]  # pierwsze 13 znaków - obręb
    dzialki_gminami[kod_gminy][kod_obrebu].append(teryt)

#! iteruję po gminach, bo dla każdej gminy tworzę nowy wniosek
for gmina in dzialki_gminami:
    print('-'*70) #? linia do oddzielenia printów dla poszczególnych gmin w konsoli Pythona
    #! lista słów dla stringu opisującego działki
    opis_dzialek = ''
    #? w zależności od liczby działek w gminie, dodajemy odpowiednie słowo
    if len(dzialki_gminami[gmina]) > 1 or any(len(dzialki) > 1 for dzialki in dzialki_gminami[gmina].values()):
        opis_dzialek += "działek"
    else:
        opis_dzialek += "działki"
    #? dodajemy obręby i ich nazwy oraz numery działek w obrębie
    for obreb, dzialki in dzialki_gminami[gmina].items():
        opis_dzialek += f" {', '.join([d.split('.')[-1] for d in dzialki])}"
        opis_dzialek += f" w obrębie {slownik_obrebow[obreb]}"
        opis_dzialek += " i"
    opis_dzialek = opis_dzialek[:-2] #? obcinam ostatnie 2 znaki (ostatnie " i")
    opis_dzialek += f" gmina {slownik_gmin[gmina]}"
    opis_dzialek += f" powiat {slownik_powiatow[gmina[:4]]}"

    with open(FOLDER_Z_DANYMI / "wniosek.txt", "r") as szablon:
        tekst_wniosku = szablon.read()
        tekst_wniosku = tekst_wniosku.replace("{{data}}", data_pisma)
        tekst_wniosku = tekst_wniosku.replace("{{nazwa_jednostki}}", adresy[gmina][0])
        tekst_wniosku = tekst_wniosku.replace("{{adres_jednostki}}", adresy[gmina][1])
        tekst_wniosku = tekst_wniosku.replace("{{kod_i_poczta}}", f"{adresy[gmina][2]} {adresy[gmina][3]}")
        tekst_wniosku = tekst_wniosku.replace("{{działki}}", opis_dzialek)
        
        #? skracam zawartość do 80 znaków, aby nie przekraczać szerokości linii
        gotowy_tekst_wniosku = '\n'.join(sum([wrap_line(l).split('\n') for l in tekst_wniosku.splitlines()], []))
        with open(FOLDER_Z_DANYMI / f"wniosek_{slownik_gmin[gmina]}_{data_pisma}.txt", "w") as plik_wynikowy:
            plik_wynikowy.write(gotowy_tekst_wniosku)
    
        print(gotowy_tekst_wniosku)
    #? dodanie info do MessageBar
    iface.messageBar().pushMessage("Wnioski", f"Pomyślnie wygenerowano wniosek dla gminy: {slownik_gmin[gmina]}", level=Qgis.Success, duration=5)
    #? dodanie info do logu QGIS
    QgsMessageLog.logMessage(f"Pomyślnie wygenerowano wniosek dla gminy: {slownik_gmin[gmina]}", 'AkcjaGenerujWnioski', level=Qgis.Success)
    
QMessageBox.information(iface.mainWindow(), 'Info', f"Pomyślnie wygenerowano wnioski dla gmin: {', '.join([slownik_gmin[gmina] for gmina in dzialki_gminami])}")
